// 2003/03/18 OptionsConfig.cs
// Copyright (C) Ortana<ortaclient@hotmail.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

using System;

namespace NTF.HXD.DOC
{
	/// <summary>
	/// OptionsJeS̐ݒB
	/// </summary>
	public class OptionsConfig : IConfig
	{
		public OptionsConfig()
		{
		}


		#region ݒ荀
		string port = "5500";
		/// <summary>
		/// T[o[̃|[gԍ
		/// </summary>
		[ValueType("UInt")]
		public string Port
		{
			get{return port;}
			set
			{
				try
				{
					uint.Parse( value );
				}
				catch
				{
					return;
				}
				port = value;
			}
		}

		string addresses = "0.0.0.0";
		/// <summary>
		/// oChAhX
		/// </summary>
		[ValueType("String")]
		public string Addresses
		{
			get{return addresses;}
			set
			{
				if( value != null && value != string.Empty )
				{
					addresses = value;
				}
			}
		}

		string version = "123";
		/// <summary>
		/// T[o[̃o[WB
		/// T[o[̃o[WɂU镑ύXB
		/// </summary>
		[ValueType("UInt&Bool")]
		public string Version
		{
			get{return version;}
			set
			{
				try
				{
					uint.Parse( value );
				}
				catch
				{
					return;
				}

				if( value != "123" && value != "185" )
				{
					return;
				}

				version = value;
			}
		}


		string away_time = "300";
		/// <summary>
		/// ݒbo߂ƃ[U[ԂawayɕύXB
		/// </summary>
		[ValueType("UInt")]
		public string Away_time
		{
			get{return away_time;}
			set
			{
				try
				{
					uint.Parse( value );
				}
				catch
				{
					return;
				}
				
				away_time = value;
			}
		}

		string ban_time = "1800";
		/// <summary>
		/// BANɐڑłȂbB
		/// </summary>
		[ValueType("UInt")]
		public string Ban_time
		{
			get{return ban_time;}
			set
			{
				try
				{
					uint.Parse( value );
				}
				catch
				{
					return;
				}

				ban_time = value;
			}
		}


		string gid = "-1";
		[ValueType("Int")]
		public string Gid
		{
			get{return gid;}
			set
			{
				try
				{
					int.Parse( value );
				}
				catch
				{
					return;
				}

				gid = value;
			}
		}

		string uid = "-1";
		[ValueType("Int")]
		public string Uid
		{
			get{return uid;}
			set
			{
				try
				{
					int.Parse( value );
				}
				catch
				{
					return;
				}

				uid = value;
			}
		}

		string detach = "0";
		[ValueType("Bool")]
		public string Detach
		{
			get{return detach;}
			set
			{
				try
				{
					uint.Parse( value );
				}
				catch
				{
					return;
				}

				if( value != "0" && value != "1")
				{
					return;
				}

				detach = value;
			}
		}

		string ident = "1";
		[ValueType("Bool")]
		public string Ident
		{
			get{return ident;}
			set
			{
				try
				{
					uint.Parse( value );
				}
				catch
				{
					return;
				}

				if( value !=  "0" && value != "1" )
				{
					return;
				}
				ident = value;
			}
		}
		#endregion
		

		public void Parse(Context context)
		{
			while(true)
			{
				string token = context.NextToken();
				if( token == null || token.Equals("}") )
				{
					break;
				}
				
				switch(token)
				{
					case"port":
						this.Port = context.NextToken();
						break;

					case"addresses":
						this.Addresses = context.NextToken();
						break;

					case"version":
						this.Version = context.NextToken();
						break;

					case"ban_time":
						this.Ban_time = context.NextToken();
						break;

					case"away_time":
						this.Away_time = context.NextToken();
						break;

					case"gid":
						this.Gid = context.NextToken();
						break;

					case"uid":
						this.Uid = context.NextToken();
						break;

					case"detach":
						this.Detach = context.NextToken();
						break;

					case"ident":
						this.Ident = context.NextToken();
						break;

					default:
						context.NextToken();
						break;
				}
			}
		}

		public System.Text.StringBuilder Save(System.Text.StringBuilder b)
		{

			ConfigWriter writer = new ConfigWriter( b );

			writer.StartCategory( "options" );
			writer.WriteComment("port to listen for htlc connections");
			writer.WriteProperty( "port" , this.Port );
			writer.WriteLine();
			writer.WriteComment("Use 123 to act as a 1.2.3 server, 185 for 1.8.5");
			writer.WriteProperty( "addresses" , this.Addresses );
			writer.WriteLine();
			writer.WriteComment("users are marked away when idle for <away_time> (seconds)");
			writer.WriteProperty("away_time" , this.Away_time );
			writer.WriteLine();
			writer.WriteComment("users are banned for <ban_time> (seconds)");
			writer.WriteProperty("ban_time" , this.Ban_time );
			writer.WriteLine();
			writer.WriteComment("gid to setgid to (-1 for none)");
			writer.WriteProperty("gid" , this.Gid );
			writer.WriteLine();
			writer.WriteComment("uid to setuid to (-1 for none)");
			writer.WriteProperty("uid" , this.Uid );
			writer.WriteLine();
			writer.WriteComment("detach from the tty at startup");
			writer.WriteProperty( "detach" , this.Detach );
			writer.WriteLine();
			writer.WriteComment("try identd; disable if you have problems with firewalls");
			writer.WriteProperty( "ident" , this.Ident );
			writer.EndCategory();

			return b;

		}

	}
}
